/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.launch.schedops.tasklets;

import com.ibm.hsc.auiml.databeans.schedops.DynamicReconfigBean;
import com.ibm.hsc.auiml.databeans.schedops.DynamicReconfigDetailsBean;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.ccfw.mom.PILparImage;
import com.ibm.hsc.websm.launch.schedops.schedulables.DynamicReconfigData;
import com.ibm.hwmca.fw.schedops.OperationParametersTasklet;
import com.ibm.hwmca.fw.schedops.OperationTarget;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DynamicReconfigSubTasklet
extends OperationParametersTasklet {
    private static final String CLASS_NAME = "[DynamicReconfigSubTasklet] ";
    private static final String TRACE_MASKT = "XTIMDYNT";
    private static final String TRACE_MASKF = "XTIMDYNF";
    private static final String TRACE_MASKD = "XTIMDYND";
    private static final String AUIML_FILE = "com.ibm.hsc.auiml.databeans.schedops.DynamicReconfig";
    private static final String BUNDLE = "com.ibm.hsc.auiml.databeans.schedops.DynamicReconfig";
    private static final String CREATE_BEAN = "DynamicReconfigBean";
    private static final String CREATE_PANEL = "DynamicReconfigPanel";
    private static final String DISPLAY_BEAN = "DynamicReconfigDetailsBean";
    private static final String DISPLAY_PANEL = "DynamicReconfigDetailsPanel";
    private static final String SAVE_BUTTON = "SaveButton";
    private static final String BUSY_TITLE = "BUSY_TITLE";
    private static final String BUSY_MSG = "BUSY_MSG";
    private static final String MEGABYTES = "MEGABYTES";
    private static final String MEGABYTES_ABBR = "MEGABYTES_ABBR";
    private Object requestType;
    private OperationTarget target;
    private DynamicReconfigData parameters;
    private static final String AS_ROOT = "/opt/hsc/bin/hscdc ";
    private static final String COMMAND = "/opt/hsc/bin/lshwres ";
    private static final String CMD_LPAR_ID = "lpar_id";
    private static final String CMD_LPAR_NAME = "lpar_name";
    private static final String CMD_BUS = "bus_id";
    private static final String CMD_DESCRIPTION = "description";
    private static final String CMD_DRC_INDEX = "drc_index";
    private static final String CMD_DRC_NAME = "drc_name";
    private static final String CMD_MODEL = "vpd_model";
    private static final String CMD_SERIAL = "vpd_serial_num";
    private static final String CMD_SLOT = "phys_loc";
    private static final String CMD_TYPE = "vpd_type";
    private static final String CMD_UNIT = "unit_phys_loc";
    private static final String CMD_CURR_MAX_MEM = "curr_max_mem";
    private static final String CMD_CURR_MEM = "curr_mem";
    private static final String CMD_CURR_MIN_MEM = "curr_min_mem";
    private static final String CMD_CURR_MAX_PROC_UNITS = "curr_max_proc_units";
    private static final String CMD_CURR_MAX_PROCS = "curr_max_procs";
    private static final String CMD_CURR_MIN_PROC_UNITS = "curr_min_proc_units";
    private static final String CMD_CURR_MIN_PROCS = "curr_min_procs";
    private static final String CMD_CURR_PROC_UNITS = "curr_proc_units";
    private static final String CMD_CURR_PROCS = "curr_procs";
    private static final String CMD_CURR_SHARING_MODE = "curr_sharing_mode";
    private static final String CMD_PROC_MODE = "curr_proc_mode";
    private static final String CMD_CURR_AVAIL_PROCS = "curr_avail_sys_proc_units";
    private static final String CMD_MAX_VIRT_PROCS = "max_virtual_procs_per_lpar";
    private static final String CMD_MIN_PROC_UNITS = "min_proc_units_per_virtual_proc";
    private static final String CMD_CURR_AVAIL_MEM = "curr_avail_sys_mem";
    private static final String CMD_MEM_REGION_SIZE = "mem_region_size";
    private static final String CMD_CAPPED = "cap";
    private static final String CMD_DEDICATED = "ded";
    private static final String CMD_IDLE = "share_idle_procs";
    private static final String CMD_NOT_OWNED = "none";
    private static final String CMD_SHARED = "shared";
    private static final String CMD_UNCAPPED = "uncap";
    private static final Pattern keyValuePattern = Pattern.compile("(.*?)=(.*?)(?:,|$)");
    private static final Matcher keyValueMatcher = keyValuePattern.matcher("");

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"[DynamicReconfigSubTasklet] >> service()");
        String string = (String)panelTaskletRequest.getData("SOURCE");
        String string2 = (String)panelTaskletRequest.getData("ACTION");
        try {
            if (panelTaskletRequest.isInitialRequest()) {
                Trace.trace((String)TRACE_MASKF, (Object)"[DynamicReconfigSubTasklet]    Processing initial request ...");
                this.requestType = panelTaskletRequest.getData("REQUEST");
                this.target = (OperationTarget)panelTaskletRequest.getData("TARGET");
                this.parameters = (DynamicReconfigData)panelTaskletRequest.getData("PARAMETERS");
                Trace.trace((String)TRACE_MASKF, (Object)("[DynamicReconfigSubTasklet]    request    = " + this.requestType));
                Trace.trace((String)TRACE_MASKF, (Object)("[DynamicReconfigSubTasklet]    target     = " + this.target));
                Trace.trace((String)TRACE_MASKF, (Object)("[DynamicReconfigSubTasklet]    parameters = " + this.parameters));
                this.processInitialRequest(panelTaskletRequest, panelTaskletResponse);
            } else {
                if (string.endsWith(CREATE_BEAN) && string2.endsWith(SAVE_BUTTON)) {
                    this.saveParameters(panelTaskletRequest);
                } else if (string2.endsWith("DATA_NOT_VALID")) {
                    Trace.trace((String)TRACE_MASKF, (Object)"[DynamicReconfigSubTasklet]    Invalid data encountered ...");
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"[DynamicReconfigSubTasklet]    Invalid request received ...");
                }
                panelTaskletResponse.noAction();
            }
        }
        catch (Exception exception) {
            throw new TaskletException((Throwable)exception);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"[DynamicReconfigSubTasklet] << service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKF, (Object)"[DynamicReconfigSubTasklet] <> logException()");
        Trace.trace((String)TRACE_MASKF, (Object)throwable);
    }

    public Object getOperationParameters() {
        if (this.parameters == null) {
            throw new IllegalStateException("parameters not set");
        }
        return this.parameters;
    }

    public void processInitialRequest(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"[DynamicReconfigSubTasklet] >> processInitialRequest()");
        this.showBusyDialog(new LocalizableText("com.ibm.hsc.auiml.databeans.schedops.DynamicReconfig", BUSY_TITLE), new LocalizableText("com.ibm.hsc.auiml.databeans.schedops.DynamicReconfig", BUSY_MSG));
        if (this.requestType.equals("REQUEST_CREATE")) {
            PanelBean panelBean = this.initializeCreateBean(panelTaskletRequest);
            panelTaskletResponse.replace("com.ibm.hsc.auiml.databeans.schedops.DynamicReconfig", CREATE_PANEL, panelBean);
        } else if (this.requestType.equals("REQUEST_DISPLAY")) {
            DynamicReconfigDetailsBean dynamicReconfigDetailsBean = new DynamicReconfigDetailsBean();
            PILparImage pILparImage = (PILparImage)this.target;
            PICec pICec = pILparImage.getCec();
            dynamicReconfigDetailsBean.setSystemName(pICec.getUserDefinedName());
            dynamicReconfigDetailsBean.setPartitionName(pILparImage.getUserDefinedName());
            dynamicReconfigDetailsBean.setDataBlock(this.parameters);
            panelTaskletResponse.replace("com.ibm.hsc.auiml.databeans.schedops.DynamicReconfig", DISPLAY_PANEL, (PanelBean)dynamicReconfigDetailsBean);
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"[DynamicReconfigSubTasklet]    Invalid initial request received ...");
            panelTaskletResponse.noAction();
        }
        this.destroyBusyDialog();
        Trace.trace((String)TRACE_MASKT, (Object)"[DynamicReconfigSubTasklet] << processInitialRequest()");
    }

    private PanelBean initializeCreateBean(PanelTaskletRequest panelTaskletRequest) {
        PILparImage pILparImage = (PILparImage)this.target;
        PICec pICec = pILparImage.getCec();
        String string = pICec.getName();
        String string2 = pICec.getUserDefinedName();
        String string3 = pILparImage.getName();
        String string4 = pILparImage.getUserDefinedName();
        String string5 = pILparImage.getPartitionNumber();
        Map map = this.collectSystemMemoryData(string);
        Map map2 = this.collectSystemProcessorData(string);
        Map[] mapArray = this.collectSystemIoData(string);
        Map[] mapArray2 = this.collectLparMemoryData(string);
        Map[] mapArray3 = this.collectLparProcessorData(string);
        Map map3 = null;
        for (int i = 0; i < mapArray3.length && map3 == null; ++i) {
            if (!string4.equals(mapArray3[i].get(CMD_LPAR_NAME))) continue;
            map3 = mapArray3[i];
        }
        Map map4 = null;
        for (int i = 0; i < mapArray2.length && map4 == null; ++i) {
            if (!string4.equals(mapArray2[i].get(CMD_LPAR_NAME))) continue;
            map4 = mapArray2[i];
        }
        DynamicReconfigBean dynamicReconfigBean = new DynamicReconfigBean();
        dynamicReconfigBean.setBeanName(CREATE_BEAN);
        DynamicReconfigData dynamicReconfigData = new DynamicReconfigData();
        dynamicReconfigData.put("SYSTEM_MTMS", string);
        dynamicReconfigData.put("SYSTEM_NAME", string2);
        dynamicReconfigData.put("SOURCE_NAME", string4);
        dynamicReconfigData.put("SOURCE_ID", string5);
        String string6 = (String)map3.get(CMD_PROC_MODE);
        if (string6.equals(CMD_DEDICATED)) {
            dynamicReconfigData.put("PROC_MODE", "DED");
        } else if (string6.equals(CMD_SHARED)) {
            dynamicReconfigData.put("PROC_MODE", "SHR");
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)("[DynamicReconfigSubTasklet]    Unknown processor mode = " + string6));
        }
        dynamicReconfigBean.setCommandParameters(dynamicReconfigData);
        dynamicReconfigBean.setSystemName(string2);
        dynamicReconfigBean.setPartitionName(string4);
        Set set = pICec.getLparImages();
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = set.iterator();
        while (object.hasNext()) {
            PILparImage pILparImage2 = (PILparImage)object.next();
            if (string4.equals(pILparImage2.getUserDefinedName())) continue;
            arrayList.add(pILparImage2.getUserDefinedName());
        }
        Collections.sort(arrayList);
        dynamicReconfigBean.setAvailableLPARs(arrayList.toArray(new String[arrayList.size()]));
        object = new LocalizableText("com.ibm.hsc.auiml.databeans.schedops.DynamicReconfig", MEGABYTES_ABBR).toString();
        dynamicReconfigBean.setA_AvailableMemory((String)map.get(CMD_CURR_AVAIL_MEM) + " " + (String)object);
        dynamicReconfigBean.setA_MemoryCurrent((String)map4.get(CMD_CURR_MEM));
        dynamicReconfigBean.setA_MemoryMax((String)map4.get(CMD_CURR_MAX_MEM));
        dynamicReconfigBean.setM_AvailableMemory((String)map.get(CMD_CURR_AVAIL_MEM) + " " + (String)object);
        dynamicReconfigBean.setM_MemoryCurrent((String)map4.get(CMD_CURR_MEM));
        dynamicReconfigBean.setM_MemoryMin((String)map4.get(CMD_CURR_MIN_MEM));
        dynamicReconfigBean.setR_AvailableMemory((String)map.get(CMD_CURR_AVAIL_MEM) + " " + (String)object);
        dynamicReconfigBean.setR_MemoryCurrent((String)map4.get(CMD_CURR_MEM));
        dynamicReconfigBean.setR_MemoryMin((String)map4.get(CMD_CURR_MIN_MEM));
        dynamicReconfigBean.setMemoryIncrement((String)map.get(CMD_MEM_REGION_SIZE));
        if (string6.equals(CMD_DEDICATED)) {
            dynamicReconfigBean.setA_AvailableProcessors((String)map2.get(CMD_CURR_AVAIL_PROCS));
            dynamicReconfigBean.setA_ProcessorsCurrent((String)map3.get(CMD_CURR_PROCS));
            dynamicReconfigBean.setA_ProcessorsMax((String)map3.get(CMD_CURR_MAX_PROCS));
            dynamicReconfigBean.setM_AvailableProcessors((String)map2.get(CMD_CURR_AVAIL_PROCS));
            dynamicReconfigBean.setM_ProcessorsCurrent((String)map3.get(CMD_CURR_PROCS));
            dynamicReconfigBean.setM_ProcessorsMin((String)map3.get(CMD_CURR_MIN_PROCS));
            dynamicReconfigBean.setR_AvailableProcessors((String)map2.get(CMD_CURR_AVAIL_PROCS));
            dynamicReconfigBean.setR_ProcessorsCurrent((String)map3.get(CMD_CURR_PROCS));
            dynamicReconfigBean.setR_ProcessorsMin((String)map3.get(CMD_CURR_MIN_PROCS));
        } else if (string6.equals(CMD_SHARED)) {
            dynamicReconfigBean.setA_AvailableProcUnits((String)map2.get(CMD_CURR_AVAIL_PROCS));
            dynamicReconfigBean.setA_ProcUnitsCurrent((String)map3.get(CMD_CURR_PROC_UNITS));
            dynamicReconfigBean.setA_ProcUnitsMax((String)map3.get(CMD_CURR_MAX_PROC_UNITS));
            dynamicReconfigBean.setA_VirtProcsCurrent((String)map3.get(CMD_CURR_PROCS));
            dynamicReconfigBean.setA_VirtProcsMax((String)map3.get(CMD_CURR_MAX_PROCS));
            dynamicReconfigBean.setM_AvailableProcUnits((String)map2.get(CMD_CURR_AVAIL_PROCS));
            dynamicReconfigBean.setM_ProcUnitsCurrent((String)map3.get(CMD_CURR_PROC_UNITS));
            dynamicReconfigBean.setM_ProcUnitsMin((String)map3.get(CMD_CURR_MIN_PROC_UNITS));
            dynamicReconfigBean.setM_VirtProcsCurrent((String)map3.get(CMD_CURR_PROCS));
            dynamicReconfigBean.setM_VirtProcsMin((String)map3.get(CMD_CURR_MIN_PROCS));
            dynamicReconfigBean.setR_AvailableProcUnits((String)map2.get(CMD_CURR_AVAIL_PROCS));
            dynamicReconfigBean.setR_ProcUnitsCurrent((String)map3.get(CMD_CURR_PROC_UNITS));
            dynamicReconfigBean.setR_ProcUnitsMin((String)map3.get(CMD_CURR_MIN_PROC_UNITS));
            dynamicReconfigBean.setR_VirtProcsCurrent((String)map3.get(CMD_CURR_PROCS));
            dynamicReconfigBean.setR_VirtProcsMin((String)map3.get(CMD_CURR_MIN_PROCS));
            dynamicReconfigBean.setMinimumProcUnitsPerVirtualProcessor((String)map2.get(CMD_MIN_PROC_UNITS));
        }
        dynamicReconfigBean.setAllAdapters(this.findAllAdapters(mapArray));
        return dynamicReconfigBean;
    }

    private Map collectSystemMemoryData(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)("[DynamicReconfigSubTasklet] <> collectSystemMemoryData() : " + string));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMAND);
        stringBuffer.append("-r mem -m ");
        stringBuffer.append(string);
        stringBuffer.append(" --level sys");
        Map[] mapArray = this.executeCommand(stringBuffer.toString());
        return mapArray.length == 0 ? new HashMap() : mapArray[0];
    }

    private Map collectSystemProcessorData(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)("[DynamicReconfigSubTasklet] <> collectSystemProcessorData() : " + string));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMAND);
        stringBuffer.append("-r proc -m ");
        stringBuffer.append(string);
        stringBuffer.append(" --level sys");
        Map[] mapArray = this.executeCommand(stringBuffer.toString());
        return mapArray.length == 0 ? new HashMap() : mapArray[0];
    }

    private Map[] collectSystemIoData(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)("[DynamicReconfigSubTasklet] <> collectSystemIoData() : " + string));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMAND);
        stringBuffer.append("-r io -m ");
        stringBuffer.append(string);
        stringBuffer.append(" --rsubtype slot");
        return this.executeCommand(stringBuffer.toString());
    }

    private Map[] collectLparMemoryData(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)"[DynamicReconfigSubTasklet] >> collectLparMemoryData()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMAND);
        stringBuffer.append("-r mem -m ");
        stringBuffer.append(string);
        stringBuffer.append(" --level lpar");
        return this.executeCommand(stringBuffer.toString());
    }

    private Map[] collectLparProcessorData(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)"[DynamicReconfigSubTasklet] >> collectLparProcessorData()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMAND);
        stringBuffer.append("-r proc -m ");
        stringBuffer.append(string);
        stringBuffer.append(" --level lpar");
        return this.executeCommand(stringBuffer.toString());
    }

    private Map[] executeCommand(String string) {
        Trace.trace((String)TRACE_MASKF, (Object)("[DynamicReconfigSubTasklet] >> ExecuteCommand : " + string));
        EExecResult eExecResult = EExec.Exec((String)string);
        if (eExecResult.rc != 0) {
            Trace.trace((String)TRACE_MASKF, (Object)("[DynamicReconfigSubTasklet] Command returned RC = " + eExecResult.rc));
            if (eExecResult.getStdout() != null) {
                Trace.trace((String)TRACE_MASKF, (Object)"[DynamicReconfigSubTasklet]    StdOut : ");
                Trace.trace((String)TRACE_MASKF, (Object)eExecResult.stdout);
            }
            if (eExecResult.getStderr() != null) {
                Trace.trace((String)TRACE_MASKF, (Object)"[DynamicReconfigSubTasklet]    StdErr : ");
                Trace.trace((String)TRACE_MASKF, (Object)eExecResult.stderr);
            }
        }
        ArrayList arrayList = new ArrayList();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(eExecResult.stdout));
        try {
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                keyValueMatcher.reset(string2);
                while (keyValueMatcher.find()) {
                    hashMap.put(keyValueMatcher.group(1), keyValueMatcher.group(2));
                }
                arrayList.add(hashMap);
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)exception);
        }
        Trace.trace((String)TRACE_MASKF, (Object)("[DynamicReconfigSubTasklet] << executeCommand() : RC = " + eExecResult.rc));
        return arrayList.toArray(new Map[arrayList.size()]);
    }

    private String[][] findAllAdapters(Map[] mapArray) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; i < mapArray.length; ++i) {
            String[] stringArray = new String[]{(String)mapArray[i].get(CMD_UNIT), (String)mapArray[i].get(CMD_BUS), (String)mapArray[i].get(CMD_SLOT), (String)mapArray[i].get(CMD_DESCRIPTION), (String)mapArray[i].get(CMD_TYPE), (String)mapArray[i].get(CMD_MODEL), (String)mapArray[i].get(CMD_SERIAL), (String)mapArray[i].get(CMD_DRC_INDEX)};
            arrayList.add(stringArray);
        }
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    private String[][] findAllocatedAdapters(Map[] mapArray, String string) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; i < mapArray.length; ++i) {
            if (!string.equals(mapArray[i].get(CMD_LPAR_NAME))) continue;
            String[] stringArray = new String[]{(String)mapArray[i].get(CMD_UNIT), (String)mapArray[i].get(CMD_BUS), (String)mapArray[i].get(CMD_SLOT), (String)mapArray[i].get(CMD_DESCRIPTION), (String)mapArray[i].get(CMD_TYPE), (String)mapArray[i].get(CMD_MODEL), (String)mapArray[i].get(CMD_SERIAL), (String)mapArray[i].get(CMD_DRC_INDEX)};
            arrayList.add(stringArray);
        }
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    private String[][] findUnallocatedAdapters(Map[] mapArray) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; i < mapArray.length; ++i) {
            if (mapArray[i].get(CMD_LPAR_NAME) != null) continue;
            String[] stringArray = new String[]{(String)mapArray[i].get(CMD_UNIT), (String)mapArray[i].get(CMD_BUS), (String)mapArray[i].get(CMD_SLOT), (String)mapArray[i].get(CMD_DESCRIPTION), (String)mapArray[i].get(CMD_TYPE), (String)mapArray[i].get(CMD_MODEL), (String)mapArray[i].get(CMD_SERIAL), (String)mapArray[i].get(CMD_DRC_INDEX)};
            arrayList.add(stringArray);
        }
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    private boolean saveParameters(PanelTaskletRequest panelTaskletRequest) {
        Trace.trace((String)TRACE_MASKF, (Object)"[DynamicReconfigSubTasklet] >> saveParameters()");
        this.parameters = (DynamicReconfigData)panelTaskletRequest.getData("DATA");
        Trace.trace((String)TRACE_MASKF, (Object)("[DynamicReconfigSubTasklet]    Command = " + this.parameters.getCommand()));
        Trace.trace((String)TRACE_MASKF, (Object)"[DynamicReconfigSubTasklet] << saveParameters()");
        return true;
    }
}

